#ifndef CSETTINGSDIALOG_H
#define CSETTINGSDIALOG_H

#include <QDialog>
#include <ui_CSettingsDialog.h>

#include <def.h>

class CSettingsDialog : public QDialog
{
    Q_OBJECT

public:
    CSettingsDialog(QWidget *parent = 0);
    ~CSettingsDialog();

public slots:
    int exec();
    void tryAccept();
    void shrink();

private slots:
    void refreshRateSliderChanged(int val);

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

private:
    Ui::CSettingsDialogClass ui;

	bool	m_multiplexOn;
	uint	m_multiplexTime;

	bool 	m_ttlOn;
	uint	m_ttlInactive;
	uint	m_ttlOutOfRange;
	uint 	m_ttlDelete;
};

#endif // CSETTINGSDIALOG_H
